/**
 * A singleton instance of a ResourcesCollection, providing access to the main set of resources for the app. If all
 * you need is this collection, prefer using this module over referencing the same collection via the App module.
 */
define([
    'backbone',
    'models/resources-collection',
    'json!resourceDirectoryJson',
],
function (Backbone, ResourcesCollection, resourceDirectory) {
    'use strict';

    return new ResourcesCollection(resourceDirectory, {parse: true});
});
